/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.persistence.analyze;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.core.annotation.AnnotatedElementUtils;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.stereotype.LazyTable;
import org.wu.framework.lazy.orm.core.stereotype.LazyTableField;
import org.wu.framework.lazy.orm.core.stereotype.LazyTableFieldUnique;
import org.wu.framework.translation.data.DefaultIEnum;
import org.wu.framework.translation.data.IEnum;

public class EasyAnnotationConverter {
    private static final String DEFAULT = "DEFAULT";

    public static String getCustomTableValue(Class clazz) {
        LazyTable lazyTable = (LazyTable)AnnotatedElementUtils.getMergedAnnotation((Class)clazz, LazyTable.class);
        if (null != lazyTable && !ObjectUtils.isEmpty((Object)lazyTable.tableName())) {
            return lazyTable.tableName();
        }
        return CamelAndUnderLineConverter.humpToLine2((String)clazz.getSimpleName());
    }

    public static List<String> getCustomUniquePK(Class clazz) {
        ArrayList<String> uniqueList = new ArrayList<String>();
        for (Field declaredField : clazz.getDeclaredFields()) {
            declaredField.setAccessible(true);
            LazyTableFieldUnique lazyTableFieldUnique = (LazyTableFieldUnique)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)declaredField, LazyTableFieldUnique.class);
            if (null == lazyTableFieldUnique) continue;
            String pk = declaredField.getName();
            if (!ObjectUtils.isEmpty((Object)lazyTableFieldUnique.value())) {
                pk = lazyTableFieldUnique.value();
            }
            uniqueList.add(pk);
        }
        return uniqueList;
    }

    public static Object annotationConvertConversion(Field field, Object fieldVal, Map<String, Map<String, String>> iEnumList) {
        if (ObjectUtils.isEmpty(iEnumList)) {
            return fieldVal;
        }
        LazyTableField lazyTableField = (LazyTableField)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, LazyTableField.class);
        if (null != lazyTableField && !DefaultIEnum.class.equals(lazyTableField.iEnum()) && lazyTableField.iEnum().isEnum()) {
            Class<? extends IEnum> e = lazyTableField.iEnum();
            if (!ObjectUtils.isEmpty((Object)fieldVal)) {
                Map<String, String> ConvertMap;
                if (fieldVal instanceof String) {
                    fieldVal = ((String)fieldVal).trim();
                }
                CharSequence[] delimiters = e.getEnumConstants()[0].getConvertContentSeparator();
                List<Object> splitContent = new ArrayList();
                splitContent = !ObjectUtils.isEmpty((Object)delimiters) ? Arrays.asList(fieldVal.toString().split(String.join((CharSequence)"|", delimiters))) : (List)fieldVal;
                ArrayList<String> res = new ArrayList<String>();
                if (!ObjectUtils.isEmpty((Object)lazyTableField.convert()) && !ObjectUtils.isEmpty(ConvertMap = iEnumList.get(lazyTableField.convert()))) {
                    for (String string : splitContent) {
                        if (!ConvertMap.containsKey(string)) continue;
                        res.add(ConvertMap.get(string));
                    }
                }
                Map<String, String> fieldMap = iEnumList.get(field.getName());
                for (String string : splitContent) {
                    if (!fieldMap.containsKey(string)) continue;
                    res.add(fieldMap.get(string));
                }
                if (ObjectUtils.isEmpty(res)) {
                    return e.getEnumConstants()[0].getDefaultCode();
                }
                return String.join((CharSequence)",", res);
            }
            return e.getEnumConstants()[0].getDefaultCode();
        }
        return fieldVal;
    }

    public static Map<String, Map<String, String>> collectionConvert(Class clazz) {
        HashMap<String, Map<String, String>> enumMap = new HashMap<String, Map<String, String>>();
        for (Field declaredField : clazz.getDeclaredFields()) {
            LazyTableField lazyTableField = (LazyTableField)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)declaredField, LazyTableField.class);
            if (null == lazyTableField || DefaultIEnum.class.equals(lazyTableField.iEnum()) || !lazyTableField.iEnum().isEnum()) continue;
            Class<? extends IEnum> e = lazyTableField.iEnum();
            Map<String, String> fieldMap = Arrays.stream(e.getEnumConstants()).collect(Collectors.toMap(IEnum::getItem, IEnum::getCode));
            enumMap.put(declaredField.getName(), fieldMap);
        }
        return enumMap;
    }

    public static String getTableName(Class clazz) {
        LazyTable lazyTable = (LazyTable)AnnotatedElementUtils.getMergedAnnotation((Class)clazz, LazyTable.class);
        if (null != lazyTable && !ObjectUtils.isEmpty((Object)lazyTable.tableName())) {
            return lazyTable.tableName();
        }
        return CamelAndUnderLineConverter.humpToLine2((String)clazz.getSimpleName());
    }

    public static String getComment(Class clazz) {
        LazyTable lazyTable = (LazyTable)AnnotatedElementUtils.getMergedAnnotation((Class)clazz, LazyTable.class);
        if (null == lazyTable) {
            return "";
        }
        return lazyTable.comment();
    }
}

