/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.factory;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.factory.LazyTableIdFactory;
import org.wu.framework.lazy.orm.core.factory.LazyTableStructureConverterFactory;
import org.wu.framework.lazy.orm.core.persistence.analyze.EasyAnnotationConverter;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyDatabaseJsonMessage;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableFieldEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableStructure;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableWeakStructure;
import org.wu.framework.lazy.orm.core.persistence.util.LazySQLUtil;
import org.wu.framework.lazy.orm.core.source.adapter.SourceFactory;
import org.wu.framework.lazy.orm.core.stereotype.LazyFieldStrategy;
import org.wu.framework.lazy.orm.core.stereotype.LazyTableFieldId;

public class LazyTableUpsertConverterFactory {
    public static String upsertRemoveNull(Object bean) {
        return LazyTableUpsertConverterFactory.insert(bean, "insert into %s (%s) VALUES %s  ON DUPLICATE KEY UPDATE \n %s", true);
    }

    public static String insertRemoveNull(Object bean) {
        return LazyTableUpsertConverterFactory.insert(bean, "insert into %s (%s) VALUES %s ", true);
    }

    public static String upsert(Object bean) {
        return LazyTableUpsertConverterFactory.insert(bean, "insert into %s (%s) VALUES %s  ON DUPLICATE KEY UPDATE \n %s");
    }

    public static String insert(Object bean) {
        return LazyTableUpsertConverterFactory.insert(bean, "insert into %s (%s) VALUES %s");
    }

    public static String insert(Object bean, String sqlStencil) {
        return LazyTableUpsertConverterFactory.insert(bean, sqlStencil, false);
    }

    public static String insert(Object bean, String sqlStencil, boolean ignoreNull) {
        LazyTableStructure lazyTableStructure = LazyTableStructureConverterFactory.dataStructure(bean);
        Object schema = lazyTableStructure.schema();
        Object payload = lazyTableStructure.payload();
        List convertedFieldList = schema.getLazyTableFieldEndpointList();
        List canBeUseFields = (ignoreNull ? (List)payload.get(0) : convertedFieldList).stream().filter(LazyTableFieldEndpoint::isExist).filter(fieldLazyTableFieldEndpoint -> {
            if (ignoreNull) {
                if (LazyTableFieldId.IdType.AUTOMATIC_ID.equals((Object)fieldLazyTableFieldEndpoint.getIdType())) {
                    return true;
                }
                return Objects.nonNull(fieldLazyTableFieldEndpoint.getFieldValue());
            }
            return true;
        }).filter(fieldLazyTableFieldEndpoint -> !LazyFieldStrategy.NEVER.equals((Object)fieldLazyTableFieldEndpoint.getUpsertStrategy())).filter(convertedField -> !LazyDatabaseJsonMessage.ignoredFields.contains(convertedField.getName())).collect(Collectors.toList());
        String column = canBeUseFields.stream().map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining(","));
        String updateColumn = canBeUseFields.stream().filter(lazyTableFieldEndpoint -> !LazyFieldStrategy.NEVER_JOIN_DUPLICATE_KEY.equals((Object)lazyTableFieldEndpoint.getUpsertStrategy())).map(convertedField -> convertedField.getColumnName() + "=" + "VALUES" + " " + "(" + convertedField.getColumnName() + ")").collect(Collectors.joining(","));
        String values = payload.stream().map(arg_0 -> LazyTableUpsertConverterFactory.lambda$insert$8(ignoreNull, (LazyTableEndpoint)schema, arg_0)).collect(Collectors.joining(","));
        return String.format(sqlStencil, schema.getFullTableName(), column, values, updateColumn);
    }

    public static String insertWeak(String schema, String table, Object bean) {
        String tableName = ObjectUtils.isEmpty((Object)schema) ? table : schema + "." + table;
        return LazyTableUpsertConverterFactory.insertWeak(bean, tableName, "insert into %s (%s) VALUES %s");
    }

    public static String upsertWeak(String schema, String table, Object bean) {
        String tableName = ObjectUtils.isEmpty((Object)schema) ? table : schema + "." + table;
        return LazyTableUpsertConverterFactory.insertWeak(bean, tableName, "insert into %s (%s) VALUES %s  ON DUPLICATE KEY UPDATE \n %s");
    }

    public static String insertWeak(Object bean, String tableName, String sqlStencil) {
        LazyTableWeakStructure lazyTableWeakStructure = LazyTableStructureConverterFactory.weakDataStructure(bean);
        String column = lazyTableWeakStructure.schema().stream().map(SourceFactory::cleanSpecialColumn).collect(Collectors.joining(","));
        column = lazyTableWeakStructure.schema().stream().map(key -> "`" + key + "`").collect(Collectors.joining(","));
        String value = lazyTableWeakStructure.payload().stream().map(valueList -> "(" + valueList.entrySet().stream().map(v -> {
            if (ObjectUtils.isEmpty(v.getValue())) {
                return null;
            }
            return v.getValue().toString();
        }).collect(Collectors.joining(",")) + ")").collect(Collectors.joining(","));
        String updateColumn = lazyTableWeakStructure.schema().stream().map(columnName -> SourceFactory.cleanSpecialColumn(columnName) + "=" + "VALUES" + " " + "(" + SourceFactory.cleanSpecialColumn(columnName) + ")").collect(Collectors.joining(","));
        return String.format(sqlStencil, tableName, column, value, updateColumn);
    }

    private static /* synthetic */ String lambda$insert$8(boolean ignoreNull, LazyTableEndpoint schema, List lazyTableFieldEndpoints) {
        return "(" + lazyTableFieldEndpoints.stream().filter(fieldLazyTableFieldEndpoint -> !ignoreNull || LazyTableFieldId.IdType.AUTOMATIC_ID.equals((Object)fieldLazyTableFieldEndpoint.getIdType()) || Objects.nonNull(fieldLazyTableFieldEndpoint.getFieldValue())).filter(fieldLazyTableFieldEndpoint -> !LazyFieldStrategy.NEVER.equals((Object)fieldLazyTableFieldEndpoint.getUpsertStrategy())).map(lazyTableFieldEndpoint -> {
            LazyFieldStrategy upsertStrategy;
            Object fieldValue = lazyTableFieldEndpoint.getFieldValue();
            if (ObjectUtils.isEmpty((Object)fieldValue) && LazyTableFieldId.IdType.INPUT_ID.equals((Object)lazyTableFieldEndpoint.getIdType())) {
                Class clazz = lazyTableFieldEndpoint.getClazz();
                fieldValue = LazyTableIdFactory.createId(clazz);
            }
            if (LazyFieldStrategy.NOT_EMPTY.equals((Object)(upsertStrategy = lazyTableFieldEndpoint.getUpsertStrategy())) && "".equals(fieldValue)) {
                throw new RuntimeException(String.format("\u5b57\u6bb5\u3010%s\u3011\u4e0d\u80fd\u4e3a\u7a7a\u5b57\u7b26\u4e32", lazyTableFieldEndpoint.getField()));
            }
            if (LazyFieldStrategy.NOT_NULL.equals((Object)upsertStrategy) && null == fieldValue) {
                throw new RuntimeException(String.format("\u5b57\u6bb5\u3010%s\u3011\u4e0d\u80fd\u4e3aNULL", fieldValue));
            }
            if (null != (fieldValue = LazySQLUtil.valueToSqlValue(fieldValue))) {
                fieldValue = EasyAnnotationConverter.annotationConvertConversion(lazyTableFieldEndpoint.getField(), fieldValue, schema.getIEnumList());
                return fieldValue.toString();
            }
            return null;
        }).collect(Collectors.joining(",")) + ")";
    }
}

