/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.factory;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.wu.framework.core.stereotype.LayerField;
import org.wu.framework.lazy.orm.core.factory.LazyTableStructureConverterFactory;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableFieldEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableStructure;
import org.wu.framework.lazy.orm.core.persistence.util.LazyFieldStrategyUtil;

public class LazyTableUpdateConverterFactory {
    public static String updateByPK(Object bean) {
        LazyTableStructure lazyTableStructure = LazyTableStructureConverterFactory.dataStructure(bean);
        LazyTableFieldEndpoint fieldEndpoint = lazyTableStructure.schema().getLazyTableFieldEndpointList().stream().filter(LazyTableFieldEndpoint::isKey).findFirst().get();
        Collection setLazyTableFieldEndpointList = lazyTableStructure.schema().getLazyTableFieldEndpointList().stream().filter(lazyTableFieldEndpoint -> LazyFieldStrategyUtil.testUpdate(lazyTableFieldEndpoint.getFieldValue(), lazyTableFieldEndpoint.getUpdateStrategy())).collect(Collectors.toList());
        String pk = fieldEndpoint.getColumnName();
        Object pkValue = fieldEndpoint.getSqlValue();
        return String.format("update %s  set %s where %s = %s ", lazyTableStructure.schema().getTableName(), setLazyTableFieldEndpointList.stream().map(lazyTableFieldEndpoint -> lazyTableFieldEndpoint.getColumnName() + "=" + lazyTableFieldEndpoint.getSqlValue()).collect(Collectors.joining(",")), pk, pkValue);
    }

    public static String updateUniqueKey(Object bean) {
        LazyTableStructure lazyTableStructure = LazyTableStructureConverterFactory.dataStructure(bean);
        Collection setLazyTableFieldEndpointList = ((List)lazyTableStructure.payload().get(0)).stream().filter(lazyTableFieldEndpoint -> LazyFieldStrategyUtil.testUpdate(lazyTableFieldEndpoint.getFieldValue(), lazyTableFieldEndpoint.getUpdateStrategy())).filter(lazyTableFieldEndpoint -> !lazyTableFieldEndpoint.isKey() || null != lazyTableFieldEndpoint.getFieldValue()).collect(Collectors.toList());
        Collection whereLazyTableFieldEndpointList = ((List)lazyTableStructure.payload().get(0)).stream().filter(lazyTableFieldEndpoint -> Arrays.stream(lazyTableFieldEndpoint.getLazyTableIndexEndpoints()).anyMatch(lazyTableIndexEndpoint -> LayerField.LayerFieldType.UNIQUE.equals((Object)lazyTableIndexEndpoint.getFieldIndexType())) && null != lazyTableFieldEndpoint.getFieldValue()).collect(Collectors.toList());
        String format = String.format("update %s  set %s where %s ", lazyTableStructure.schema().getTableName(), setLazyTableFieldEndpointList.stream().map(lazyTableFieldEndpoint -> lazyTableFieldEndpoint.getColumnName() + "=" + lazyTableFieldEndpoint.getSqlValue()).collect(Collectors.joining(",")), whereLazyTableFieldEndpointList.stream().map(lazyTableFieldEndpoint -> lazyTableFieldEndpoint.getColumnName() + "=" + lazyTableFieldEndpoint.getSqlValue()).collect(Collectors.joining(" and ")));
        return format;
    }
}

