/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.factory;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.core.ReflexUtils;
import org.wu.framework.core.exception.AssertFactory;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableFieldEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableStructure;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableWeakStructure;
import org.wu.framework.lazy.orm.core.persistence.conf.mysql.ClassLazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.map.EasyHashMap;
import org.wu.framework.lazy.orm.core.persistence.util.LazySQLUtil;
import org.wu.framework.lazy.orm.core.source.adapter.SourceFactory;

public class LazyTableStructureConverterFactory {
    public static LazyTableStructure dataStructure(Object source) {
        AssertFactory.notNull((Object)source, (String)"source \u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Class<?> sourceClass = source.getClass();
        if (Collection.class.isAssignableFrom(sourceClass)) {
            return LazyTableStructureConverterFactory.wrapperIterable((Iterable)source);
        }
        if (EasyHashMap.class.isAssignableFrom(sourceClass)) {
            return LazyTableStructureConverterFactory.wrapperEasyHashMap((EasyHashMap)source);
        }
        if (sourceClass.isArray()) {
            return LazyTableStructureConverterFactory.wrapperArray((Object[])source);
        }
        return LazyTableStructureConverterFactory.wrapperBean(source);
    }

    public static LazyTableStructure wrapperIterable(Iterable<?> iterable) {
        LazyTableStructure lazyTableStructure;
        boolean isBean;
        Object next = iterable.iterator().next();
        Class<?> nextClass = next.getClass();
        Object lazyTableEndpoint = null;
        if (EasyHashMap.class.isAssignableFrom(nextClass)) {
            isBean = false;
            lazyTableStructure = LazyTableStructureConverterFactory.wrapperEasyHashMap((EasyHashMap)next);
            lazyTableEndpoint = lazyTableStructure.schema();
        } else if (Object.class.isAssignableFrom(nextClass)) {
            isBean = true;
            lazyTableStructure = LazyTableStructureConverterFactory.wrapperBean(next);
            lazyTableEndpoint = lazyTableStructure.schema();
        } else {
            isBean = false;
        }
        List<List<LazyTableFieldEndpoint>> fieldValueList = ((Stream)StreamSupport.stream(iterable.spliterator(), true).parallel()).map(o -> {
            LazyTableStructure lazyTableStructure = isBean ? LazyTableStructureConverterFactory.wrapperBean(o) : LazyTableStructureConverterFactory.wrapperEasyHashMap((EasyHashMap)o);
            return (List)lazyTableStructure.payload().get(0);
        }).collect(Collectors.toList());
        return new LazyTableStructure((LazyTableEndpoint<? extends LazyTableFieldEndpoint>)lazyTableEndpoint, fieldValueList);
    }

    private static LazyTableStructure wrapperArray(Object[] array) {
        Object lazyTableEndpoint;
        ArrayList<List<LazyTableFieldEndpoint>> fieldValueList;
        block5: {
            boolean hasCalculation;
            Class<?> nextClass;
            block4: {
                Object next = array[0];
                nextClass = next.getClass();
                fieldValueList = new ArrayList<List<LazyTableFieldEndpoint>>();
                hasCalculation = false;
                lazyTableEndpoint = null;
                if (!EasyHashMap.class.isAssignableFrom(nextClass)) break block4;
                for (Object o : array) {
                    LazyTableStructure lazyTableStructure = LazyTableStructureConverterFactory.wrapperEasyHashMap((EasyHashMap)o);
                    if (!hasCalculation) {
                        hasCalculation = true;
                        lazyTableEndpoint = lazyTableStructure.schema();
                    }
                    fieldValueList.add((List<LazyTableFieldEndpoint>)lazyTableStructure.payload().get(0));
                }
                break block5;
            }
            if (!Object.class.isAssignableFrom(nextClass)) break block5;
            for (Object o : array) {
                LazyTableStructure lazyTableStructure = LazyTableStructureConverterFactory.wrapperBean(o);
                if (!hasCalculation) {
                    hasCalculation = true;
                    lazyTableEndpoint = lazyTableStructure.schema();
                }
                fieldValueList.add((List<LazyTableFieldEndpoint>)lazyTableStructure.payload().get(0));
            }
        }
        return new LazyTableStructure((LazyTableEndpoint<? extends LazyTableFieldEndpoint>)lazyTableEndpoint, (List<List<LazyTableFieldEndpoint>>)fieldValueList);
    }

    public static LazyTableStructure wrapperEasyHashMap(EasyHashMap<?, ?> easyHashMap) {
        ClassLazyTableEndpoint lazyTableEndpoint = easyHashMap.toEasyTableAnnotation(false, true);
        List<LazyTableFieldEndpoint> fieldLazyTableFieldEndpointList = easyHashMap.getFieldLazyTableFieldEndpointList();
        List thisFieldEndpointList = lazyTableEndpoint.toThisFieldEndpointList(fieldLazyTableFieldEndpointList);
        return new LazyTableStructure(lazyTableEndpoint, Arrays.asList(fieldLazyTableFieldEndpointList));
    }

    public static LazyTableStructure wrapperBean(Object o) {
        AssertFactory.notNull((Object)o, (String)"source \u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Class<?> oClass = o.getClass();
        LazyTableEndpoint<?> lazyTableEndpoint = SourceFactory.defaultAnalyzeLazyTableFromClass(oClass);
        List fieldValueList = lazyTableEndpoint.getLazyTableFieldEndpointList().stream().filter(LazyTableFieldEndpoint::isExist).map(fieldLazyTableFieldEndpoint -> {
            try {
                LazyTableFieldEndpoint clone = fieldLazyTableFieldEndpoint.clone();
                Field field = clone.getField();
                Object fieldValue = field.get(o);
                clone.setFieldValue(fieldValue);
                return clone;
            }
            catch (CloneNotSupportedException | IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
        }).collect(Collectors.toList());
        return new LazyTableStructure(lazyTableEndpoint, Arrays.asList(fieldValueList));
    }

    public static LazyTableWeakStructure weakDataStructure(Object source) {
        AssertFactory.notNull((Object)source, (String)"source \u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Class<?> sourceClass = source.getClass();
        if (Collection.class.isAssignableFrom(sourceClass)) {
            return LazyTableStructureConverterFactory.wrapperWeakIterable((Iterable)source);
        }
        if (Map.class.isAssignableFrom(sourceClass)) {
            return LazyTableStructureConverterFactory.wrapperWeakSingleMap((Map)source);
        }
        if (sourceClass.isArray()) {
            return LazyTableStructureConverterFactory.wrapperWeakArray((Object[])source);
        }
        return LazyTableStructureConverterFactory.wrapperWeakSingleBean(source);
    }

    public static LazyTableWeakStructure wrapperWeakIterable(Iterable<?> iterable) {
        LazyTableWeakStructure lazyTableStructure;
        boolean isBean;
        Object next = iterable.iterator().next();
        Class<?> nextClass = next.getClass();
        Object schema = null;
        if (Map.class.isAssignableFrom(nextClass)) {
            isBean = false;
            lazyTableStructure = LazyTableStructureConverterFactory.wrapperWeakSingleMap((Map)next);
            schema = lazyTableStructure.schema();
        } else if (Object.class.isAssignableFrom(nextClass)) {
            isBean = true;
            lazyTableStructure = LazyTableStructureConverterFactory.wrapperWeakSingleBean(next);
            schema = lazyTableStructure.schema();
        } else {
            isBean = false;
        }
        List<Map<String, Object>> fieldValueList = ((Stream)StreamSupport.stream(iterable.spliterator(), true).parallel()).map(o -> {
            LazyTableWeakStructure lazyTableStructure = isBean ? LazyTableStructureConverterFactory.wrapperWeakSingleBean(o) : LazyTableStructureConverterFactory.wrapperWeakSingleMap((Map)o);
            return (Map)lazyTableStructure.payload().get(0);
        }).collect(Collectors.toList());
        return new LazyTableWeakStructure((List<String>)schema, fieldValueList);
    }

    private static LazyTableWeakStructure wrapperWeakArray(Object[] array) {
        Object schema;
        ArrayList<Map<String, Object>> fieldValueList;
        block5: {
            boolean hasCalculation;
            Class<?> nextClass;
            block4: {
                Object next = array[0];
                nextClass = next.getClass();
                fieldValueList = new ArrayList<Map<String, Object>>();
                hasCalculation = false;
                schema = null;
                if (!Map.class.isAssignableFrom(nextClass)) break block4;
                for (Object o : array) {
                    LazyTableWeakStructure lazyTableStructure = LazyTableStructureConverterFactory.wrapperWeakSingleMap((Map)o);
                    if (!hasCalculation) {
                        hasCalculation = true;
                        schema = lazyTableStructure.schema();
                    }
                    fieldValueList.add((Map<String, Object>)lazyTableStructure.payload().get(0));
                }
                break block5;
            }
            if (!Object.class.isAssignableFrom(nextClass)) break block5;
            for (Object o : array) {
                LazyTableWeakStructure lazyTableStructure = LazyTableStructureConverterFactory.wrapperWeakSingleBean(o);
                if (!hasCalculation) {
                    hasCalculation = true;
                    schema = lazyTableStructure.schema();
                }
                fieldValueList.add((Map<String, Object>)lazyTableStructure.payload().get(0));
            }
        }
        return new LazyTableWeakStructure((List<String>)schema, (List<Map<String, Object>>)fieldValueList);
    }

    private static LazyTableWeakStructure wrapperWeakSingleMap(Map<?, ?> source) {
        ArrayList<String> schema = new ArrayList<String>();
        HashMap payload = new HashMap();
        source.entrySet().stream().filter(entry -> !ObjectUtils.isEmpty(entry.getValue())).forEach(entry -> {
            Object key = entry.getKey();
            Object value = entry.getValue();
            schema.add(key.toString());
            payload.put(key.toString(), LazySQLUtil.valueToSqlValue(value));
        });
        return new LazyTableWeakStructure(schema, Arrays.asList(payload));
    }

    private static LazyTableWeakStructure wrapperWeakSingleBean(Object source) {
        ArrayList<String> schema = new ArrayList<String>();
        HashMap<String, Object> payload = new HashMap<String, Object>();
        for (Field declaredField : source.getClass().getDeclaredFields()) {
            String fieldName = declaredField.getName();
            String key = CamelAndUnderLineConverter.humpToLine2((String)fieldName);
            Object value = ReflexUtils.findDeclaredFieldBean((Object)source, (Field)declaredField);
            if (ObjectUtils.isEmpty((Object)value)) continue;
            schema.add(key);
            payload.put(key, LazySQLUtil.valueToSqlValue(value));
        }
        return new LazyTableWeakStructure(schema, Arrays.asList(payload));
    }
}

