/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.factory;

import java.util.concurrent.ConcurrentHashMap;
import org.wu.framework.lazy.orm.core.factory.LongIdCreator;
import org.wu.framework.lazy.orm.core.factory.StringIdCreator;

public class LazyTableIdFactory {
    protected static final ConcurrentHashMap<Class<?>, CreateId> CONCURRENT_CREATE_ID_HASH_MAP = new ConcurrentHashMap(){
        {
            this.put(String.class, new StringIdCreator());
            this.put(Long.class, new LongIdCreator());
        }
    };

    public static Object createId(Class<?> idClassType) {
        if (CONCURRENT_CREATE_ID_HASH_MAP.containsKey(idClassType)) {
            return CONCURRENT_CREATE_ID_HASH_MAP.get(idClassType).createId();
        }
        System.err.println("idClassType = " + idClassType);
        return null;
    }

    public static interface CreateId {
        public Object createId();
    }
}

