/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.config.prop;

import javax.sql.DataSource;
import lombok.Generated;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.config.enums.LazyDataSourceType;
import org.wu.framework.lazy.orm.core.config.prop.LazyDataSourceAttribute;
import org.wu.framework.lazy.orm.core.source.adapter.SourceFactory;

public abstract class AbstractLazyDataSourceAttribute
implements LazyDataSourceAttribute {
    private String alias = "master";
    private String url;
    private String username;
    private String password;
    private String driverClassName;
    private Class<? extends DataSource> type;
    private LazyDataSourceType lazyDataSourceType;
    private boolean useProxy = true;

    public String switchDriverClassName() {
        if (ObjectUtils.isEmpty((Object)this.driverClassName)) {
            LazyDataSourceType lazyDataSourceType = this.getLazyDataSourceType();
            return lazyDataSourceType.getDriver();
        }
        return this.driverClassName;
    }

    @Override
    public LazyDataSourceType getLazyDataSourceType() {
        if (ObjectUtils.isEmpty((Object)((Object)this.lazyDataSourceType))) {
            this.lazyDataSourceType = SourceFactory.getLazyDataSourceType(this.url);
        }
        return this.lazyDataSourceType;
    }

    @Override
    public DataSource getDatasource() {
        if (SourceFactory.defaultLazyDataSourceType == null) {
            SourceFactory.defaultLazyDataSourceType = this.getLazyDataSourceType();
        }
        return this.doGetDatasource();
    }

    @Override
    public String getUrl() {
        if (ObjectUtils.isEmpty((Object)this.url)) {
            throw new IllegalArgumentException("\u914d\u7f6e\u6570\u636e\u5e93url\u9519\u8bef\u8bf7\u6b63\u786e\u914d\u7f6eurl");
        }
        return SourceFactory.formatUrl(this.url);
    }

    public abstract DataSource doGetDatasource();

    public Class<? extends DataSource> switchType() {
        if (ObjectUtils.isEmpty(this.type)) {
            try {
                LazyDataSourceType dataSourceType = this.getLazyDataSourceType();
                String dataSourceClass = dataSourceType.getDataSourceClass();
                Class<?> clazz = Class.forName(dataSourceClass);
                return clazz;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("\u65e0\u6cd5\u521d\u59cb\u5316\u6570\u636e\u6e90\uff0c\u8bf7\u914d\u7f6e\u6570\u636e\u6e90\u7c7b\u578b: spring.datasource.type='',\u5f53\u524d\u914d\u7f6e\uff1a" + this);
            }
        }
        return this.type;
    }

    @Generated
    public AbstractLazyDataSourceAttribute() {
    }

    @Override
    @Generated
    public String getAlias() {
        return this.alias;
    }

    @Override
    @Generated
    public String getUsername() {
        return this.username;
    }

    @Override
    @Generated
    public String getPassword() {
        return this.password;
    }

    @Override
    @Generated
    public String getDriverClassName() {
        return this.driverClassName;
    }

    @Override
    @Generated
    public Class<? extends DataSource> getType() {
        return this.type;
    }

    @Generated
    public boolean isUseProxy() {
        return this.useProxy;
    }

    @Override
    @Generated
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    @Generated
    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    @Override
    @Generated
    public void setType(Class<? extends DataSource> type) {
        this.type = type;
    }

    @Override
    @Generated
    public void setLazyDataSourceType(LazyDataSourceType lazyDataSourceType) {
        this.lazyDataSourceType = lazyDataSourceType;
    }

    @Generated
    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractLazyDataSourceAttribute)) {
            return false;
        }
        AbstractLazyDataSourceAttribute other = (AbstractLazyDataSourceAttribute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseProxy() != other.isUseProxy()) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$driverClassName = this.getDriverClassName();
        String other$driverClassName = other.getDriverClassName();
        if (this$driverClassName == null ? other$driverClassName != null : !this$driverClassName.equals(other$driverClassName)) {
            return false;
        }
        Class<? extends DataSource> this$type = this.getType();
        Class<? extends DataSource> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        LazyDataSourceType this$lazyDataSourceType = this.getLazyDataSourceType();
        LazyDataSourceType other$lazyDataSourceType = other.getLazyDataSourceType();
        return !(this$lazyDataSourceType == null ? other$lazyDataSourceType != null : !((Object)((Object)this$lazyDataSourceType)).equals((Object)other$lazyDataSourceType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractLazyDataSourceAttribute;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseProxy() ? 79 : 97);
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $driverClassName = this.getDriverClassName();
        result = result * 59 + ($driverClassName == null ? 43 : $driverClassName.hashCode());
        Class<? extends DataSource> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        LazyDataSourceType $lazyDataSourceType = this.getLazyDataSourceType();
        result = result * 59 + ($lazyDataSourceType == null ? 43 : ((Object)((Object)$lazyDataSourceType)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbstractLazyDataSourceAttribute(alias=" + this.getAlias() + ", url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", driverClassName=" + this.getDriverClassName() + ", type=" + this.getType() + ", lazyDataSourceType=" + (Object)((Object)this.getLazyDataSourceType()) + ", useProxy=" + this.isUseProxy() + ")";
    }
}

