/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.database.datasource.proxy.toolkit;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.database.datasource.proxy.sql.LazySQLContext;

public final class DynamicLazySQLContextHolder {
    private static final ThreadLocal<Deque<List<LazySQLContext>>> LOOKUP_KEY_HOLDER = ThreadLocal.withInitial(ArrayDeque::new);

    private DynamicLazySQLContextHolder() {
    }

    public static List<LazySQLContext> peek() {
        return LOOKUP_KEY_HOLDER.get().peek();
    }

    public static <T> void push(LazySQLContext attribute) {
        if (null == attribute) {
            return;
        }
        List<LazySQLContext> peek = DynamicLazySQLContextHolder.peek();
        if (ObjectUtils.isEmpty(peek)) {
            peek = new ArrayList<LazySQLContext>();
        }
        peek.add(attribute);
        LOOKUP_KEY_HOLDER.get().push(peek);
    }

    public static void poll() {
        Deque<List<LazySQLContext>> deque = LOOKUP_KEY_HOLDER.get();
        deque.poll();
        if (deque.isEmpty()) {
            LOOKUP_KEY_HOLDER.remove();
        }
    }

    public static void clear() {
        LOOKUP_KEY_HOLDER.remove();
    }
}

