/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.database.datasource.proxy.toolkit;

import java.util.ArrayDeque;
import java.util.Deque;
import org.wu.framework.lazy.database.datasource.proxy.toolkit.AuditStatus;

public final class DynamicLazySQLAuditStatusHolder {
    private static final ThreadLocal<Deque<AuditStatus>> LOOKUP_KEY_HOLDER = ThreadLocal.withInitial(ArrayDeque::new);

    private DynamicLazySQLAuditStatusHolder() {
    }

    public static AuditStatus peek() {
        return LOOKUP_KEY_HOLDER.get().peek();
    }

    public static <T> void push(AuditStatus status) {
        LOOKUP_KEY_HOLDER.get().push(status);
    }

    public static void poll() {
        Deque<AuditStatus> deque = LOOKUP_KEY_HOLDER.get();
        deque.poll();
        if (deque.isEmpty()) {
            LOOKUP_KEY_HOLDER.remove();
        }
    }

    public static void clear() {
        LOOKUP_KEY_HOLDER.remove();
    }
}

