/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.database.datasource.proxy.handler;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.wu.framework.core.Ordered;
import org.wu.framework.core.exception.AssertFactory;
import org.wu.framework.lazy.database.datasource.proxy.audit.LazyAuditAdapter;
import org.wu.framework.lazy.database.datasource.proxy.handler.ConnectionHandler;
import org.wu.framework.lazy.database.datasource.proxy.handler.DataSourceHandler;
import org.wu.framework.lazy.database.datasource.proxy.handler.LazyConnectionHandler;
import org.wu.framework.lazy.database.datasource.proxy.handler.LazyDataSourceHandler;

public class JdbcHandlerAdapter {
    private final List<DataSourceHandler> dataSourceHandlerList;
    private final List<ConnectionHandler> connectionHandlerList;
    private final LazyAuditAdapter lazyAuditAdapter;

    public JdbcHandlerAdapter() {
        this.dataSourceHandlerList = Arrays.asList(new LazyDataSourceHandler());
        this.connectionHandlerList = Arrays.asList(new LazyConnectionHandler());
        this.lazyAuditAdapter = null;
    }

    public JdbcHandlerAdapter(List<DataSourceHandler> dataSourceHandlerList, List<ConnectionHandler> connectionHandlerList, LazyAuditAdapter lazyAuditAdapter) {
        this.dataSourceHandlerList = dataSourceHandlerList;
        this.connectionHandlerList = connectionHandlerList;
        this.lazyAuditAdapter = lazyAuditAdapter;
    }

    public DataSourceHandler findFirstDataSourceHandler() {
        AssertFactory.notNull(this.dataSourceHandlerList, (String)"\u6570\u636e\u6e90\u5904\u7406\u5668\u4e0d\u80fd\u4e3a\u7a7a");
        return this.dataSourceHandlerList.stream().sorted(Comparator.comparing(Ordered::getOrder)).findFirst().get();
    }

    public ConnectionHandler findFirstConnectionHandler() {
        AssertFactory.notNull(this.connectionHandlerList, (String)"\u6570\u636e\u5e93\u8fde\u63a5\u5904\u7406\u5668\u4e0d\u80fd\u4e3a\u7a7a");
        return this.connectionHandlerList.stream().sorted(Comparator.comparing(Ordered::getOrder)).findFirst().get();
    }

    public LazyAuditAdapter findLazyAuditAdapter() {
        return this.lazyAuditAdapter;
    }
}

