/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.database.datasource.proxy.connection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.Statement;
import javax.sql.DataSource;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.database.datasource.proxy.connection.LazyProxyConnection;
import org.wu.framework.lazy.database.datasource.proxy.handler.ConnectionHandler;
import org.wu.framework.lazy.database.datasource.proxy.handler.JdbcHandlerAdapter;
import org.wu.framework.lazy.database.datasource.proxy.sql.LazySQLContext;

public class LazyConnectionInvocationHandler
implements InvocationHandler {
    private final DataSource targetDataSource;
    private final Connection targetConnection;
    private final JdbcHandlerAdapter jdbcHandlerAdapter;

    public LazyConnectionInvocationHandler(DataSource targetDataSource, Connection targetConnection, JdbcHandlerAdapter jdbcHandlerAdapter) {
        this.targetDataSource = targetDataSource;
        this.targetConnection = targetConnection;
        this.jdbcHandlerAdapter = jdbcHandlerAdapter;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            ConnectionHandler connectionHandler = this.jdbcHandlerAdapter.findFirstConnectionHandler();
            String name = method.getName();
            if (name.equals("isConnectionTransactional")) {
                return connectionHandler.isConnectionTransactional(this.targetDataSource, (Connection)proxy);
            }
            if (this.isConnectionCloseMethod(method)) {
                connectionHandler.connectionClose(this.targetDataSource, (Connection)proxy);
                return Void.TYPE;
            }
            if (this.isSetAutoCommitMethod(method, args)) {
                connectionHandler.setAutoCommit(this.targetDataSource, this.targetConnection, (Boolean)args[0]);
                return Void.TYPE;
            }
            if (this.isGetAutoCommitMethod(method, args)) {
                return connectionHandler.getAutoCommit(this.targetDataSource, this.targetConnection);
            }
            if (this.isCommitMethod(method, args)) {
                connectionHandler.commit(this.targetDataSource, this.targetConnection);
                return Void.TYPE;
            }
            if (this.isRollbackMethod(method, args)) {
                connectionHandler.rollback(this.targetDataSource, this.targetConnection);
                return Void.TYPE;
            }
            long startTime = System.currentTimeMillis();
            Object invoke = method.invoke((Object)this.targetConnection, args);
            long endTime = System.currentTimeMillis();
            if (this.jdbcHandlerAdapter.findLazyAuditAdapter() != null && invoke instanceof Statement) {
                LazySQLContext lazySQLContext = new LazySQLContext();
                lazySQLContext.setBeginTime(startTime);
                lazySQLContext.setEndTime(endTime);
                if (invoke != null) {
                    lazySQLContext.setSql(invoke.toString());
                    this.jdbcHandlerAdapter.findLazyAuditAdapter().audit(lazySQLContext);
                }
            }
            return invoke;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw throwable;
        }
    }

    protected boolean isRollbackMethod(Method method, Object[] args) {
        return method.getName().equals("rollback") && ObjectUtils.isEmpty((Object)args);
    }

    protected boolean isCommitMethod(Method method, Object[] args) {
        return method.getName().equals("commit") && ObjectUtils.isEmpty((Object)args);
    }

    protected boolean isGetAutoCommitMethod(Method method, Object[] args) {
        return method.getName().equals("getAutoCommit");
    }

    protected boolean isSetAutoCommitMethod(Method method, Object[] args) {
        return method.getName().equals("setAutoCommit");
    }

    protected boolean isConnectionCloseMethod(Method method) {
        return method.getName().equals("connectionClose") && method.getParameterCount() == 0;
    }

    public static <A extends Connection> A createProxy(DataSource dataSource, Connection connection) {
        return LazyConnectionInvocationHandler.createProxy(dataSource, connection, new JdbcHandlerAdapter());
    }

    public static <A extends Connection> A createProxy(DataSource targetDataSource, Connection targetConnection, JdbcHandlerAdapter jdbcHandlerAdapter) {
        ClassLoader classLoader = LazyProxyConnection.class.getClassLoader();
        Class[] interfaces = new Class[]{LazyProxyConnection.class};
        LazyConnectionInvocationHandler handler = new LazyConnectionInvocationHandler(targetDataSource, targetConnection, jdbcHandlerAdapter);
        return (A)((Connection)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)handler));
    }
}

