/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.database.datasource.proxy;

import java.io.PrintWriter;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import lombok.Generated;
import org.wu.framework.bean.factory.BeanFactory;
import org.wu.framework.lazy.database.datasource.proxy.AbstractLazyDataSource;
import org.wu.framework.lazy.database.datasource.proxy.LazyDataSource;
import org.wu.framework.lazy.database.datasource.proxy.connection.LazyConnectionInvocationHandler;
import org.wu.framework.lazy.database.datasource.proxy.connection.LazyProxyConnection;
import org.wu.framework.lazy.database.datasource.proxy.properties.LazyWideDataSourceProperties;

public class LazyWideDataSource
extends AbstractLazyDataSource
implements LazyDataSource {
    private String username;
    private String password;
    private String url;
    private String driverClassName;
    private LazyWideDataSourceProperties lazyWideDataSourceProperties;

    @Override
    public LazyProxyConnection getConnection() throws SQLException {
        return this.getConnection(this.username, this.password);
    }

    @Override
    public LazyProxyConnection getConnection(String username, String password) throws SQLException {
        try {
            Class<?> driverClass = Class.forName(this.driverClassName);
            Driver driver = (Driver)BeanFactory.getInstance(driverClass);
            Properties properties = new Properties();
            properties.setProperty("user", username);
            properties.setProperty("username", username);
            properties.setProperty("password", password);
            return (LazyProxyConnection)LazyConnectionInvocationHandler.createProxy(this, driver.connect(this.url, properties));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LazyWideDataSource)) {
            return false;
        }
        LazyWideDataSource other = (LazyWideDataSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$driverClassName = this.getDriverClassName();
        String other$driverClassName = other.getDriverClassName();
        if (this$driverClassName == null ? other$driverClassName != null : !this$driverClassName.equals(other$driverClassName)) {
            return false;
        }
        LazyWideDataSourceProperties this$lazyWideDataSourceProperties = this.getLazyWideDataSourceProperties();
        LazyWideDataSourceProperties other$lazyWideDataSourceProperties = other.getLazyWideDataSourceProperties();
        return !(this$lazyWideDataSourceProperties == null ? other$lazyWideDataSourceProperties != null : !((Object)this$lazyWideDataSourceProperties).equals(other$lazyWideDataSourceProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LazyWideDataSource;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $driverClassName = this.getDriverClassName();
        result = result * 59 + ($driverClassName == null ? 43 : $driverClassName.hashCode());
        LazyWideDataSourceProperties $lazyWideDataSourceProperties = this.getLazyWideDataSourceProperties();
        result = result * 59 + ($lazyWideDataSourceProperties == null ? 43 : ((Object)$lazyWideDataSourceProperties).hashCode());
        return result;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getDriverClassName() {
        return this.driverClassName;
    }

    @Generated
    public LazyWideDataSourceProperties getLazyWideDataSourceProperties() {
        return this.lazyWideDataSourceProperties;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    @Generated
    public String toString() {
        return "LazyWideDataSource(username=" + this.getUsername() + ", password=" + this.getPassword() + ", url=" + this.getUrl() + ", driverClassName=" + this.getDriverClassName() + ", lazyWideDataSourceProperties=" + this.getLazyWideDataSourceProperties() + ")";
    }

    @Generated
    public void setLazyWideDataSourceProperties(LazyWideDataSourceProperties lazyWideDataSourceProperties) {
        this.lazyWideDataSourceProperties = lazyWideDataSourceProperties;
    }
}

