/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.database.datasource.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import javax.sql.DataSource;
import org.wu.framework.core.ReflexUtils;
import org.wu.framework.lazy.database.datasource.proxy.LazyProxyDataSource;
import org.wu.framework.lazy.database.datasource.proxy.connection.LazyConnectionInvocationHandler;
import org.wu.framework.lazy.database.datasource.proxy.handler.JdbcHandlerAdapter;

public class LazyProxyDataSourceInvocationHandler
implements InvocationHandler {
    private final DataSource targetDataSource;
    private final JdbcHandlerAdapter jdbcHandlerAdapter;

    public LazyProxyDataSourceInvocationHandler(DataSource targetDataSource, JdbcHandlerAdapter jdbcHandlerAdapter) {
        this.targetDataSource = targetDataSource;
        this.jdbcHandlerAdapter = jdbcHandlerAdapter;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (this.isCloseMethod(method, args)) {
                if (ReflexUtils.existsDeclaredMethod(this.targetDataSource.getClass(), (String)"connectionClose", (Class[])new Class[0]).booleanValue()) {
                    Method declaredMethod = ReflexUtils.findDeclaredMethod(this.targetDataSource.getClass(), (String)"connectionClose", (Class[])new Class[0]);
                    ReflexUtils.invokeDeclaredMethod((Object)this.targetDataSource, (Method)declaredMethod, (Object[])new Object[0]);
                }
                return null;
            }
            if (this.isGetLazyConnectionMethod(method)) {
                return this.jdbcHandlerAdapter.findFirstDataSourceHandler().getLazyConnection((DataSource)proxy);
            }
            Object invoke = method.invoke((Object)this.targetDataSource, args);
            if (invoke instanceof Connection) {
                return LazyConnectionInvocationHandler.createProxy(this.targetDataSource, (Connection)invoke, this.jdbcHandlerAdapter);
            }
            return invoke;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw throwable;
        }
    }

    protected boolean isGetLazyConnectionMethod(Method method) {
        return method.getName().equals("getLazyConnection") && method.getParameterCount() == 0;
    }

    protected boolean isCloseMethod(Method method, Object[] args) {
        return method.getName().equals("connectionClose");
    }

    public static <A extends DataSource> A createProxy(DataSource dataSource) {
        return LazyProxyDataSourceInvocationHandler.createProxy(dataSource, new JdbcHandlerAdapter());
    }

    public static <A extends DataSource> A createProxy(DataSource dataSource, JdbcHandlerAdapter jdbcHandlerAdapter) {
        ClassLoader classLoader = LazyProxyDataSource.class.getClassLoader();
        Class[] interfaces = new Class[]{LazyProxyDataSource.class};
        LazyProxyDataSourceInvocationHandler handler = new LazyProxyDataSourceInvocationHandler(dataSource, jdbcHandlerAdapter);
        return (A)((DataSource)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)handler));
    }
}

